<?php 
namespace App\Controllers\User;  
use CodeIgniter\Controller;
use App\Controllers\BaseController;
use App\Models\UserModel;
use App\Models\LicenseModel;
class SignupController extends BaseController
{
    protected $session;
    
    public function __construct(){
        helper(['form']);
        $this->session = service('session');
    }
    public function index()
    {
        helper(['form']);
        $data = ['title' => 'Register'];
        $data['msg'] = $this->session->getFlashdata('msg');
        $data['error'] = $this->session->getFlashdata('error');
        $this->smartyView('auth/signup', $data);
    }

   public function is_unique($table,$value)
    {
        $userModel = new UserModel();
        $user = $userModel->where($table, $value)->findAll();
        if(!empty($user[0])){
            return TRUE;
        }else {
            return FALSE;
        }
    }
    public function store()
    {
                if(getenv('REG_BONUS_ACTIVE') == 0){
             $rules = [
                'user' => [
                        'label'  => 'Usuario',
                        'rules'  => 'required|min_length[5]|max_length[20]',
                        'errors' => [
                        'required' => 'Seu {field} nao pode ser vazio',
                        'min_length' => '{field} deve ter no mino 5 letras ou numeros',
                        'max_length' => '{field} deve ter no maximo 20 letras ou numeros'
                    ]
                ],
                'email' => [
                        'label'  => 'Email',
                        'rules'  => 'required|min_length[5]|max_length[50]|valid_email',
                        'errors' => [
                        'required' => 'Seus {field} nao pode ser vazio',
                        'valid_email' => 'Formato do {field} deve ser valido',
                        'min_length' => '{field} deve ter no mino 5 letras ou numeros',
                        'max_length' => '{field} deve ter no maximo 20 letras ou numeros'
                    ]
                ],
                'password' => [
                        'label'  => 'Senha',
                        'rules'  => 'required|min_length[5]|max_length[50]',
                        'errors' => [
                        'required' => 'Sua {field} nao pode ser vazio',
                        'min_length' => '{field} deve ter no mino 5 letras ou numeros',
                        'max_length' => '{field} deve ter no maximo 20 letras ou numeros'
                    ]
                ],
                'customername' => [
                        'label'  => 'CustomerName',
                        'rules'  => 'required|min_length[5]|max_length[50]',
                        'errors' => [
                        'required' => 'Seu {field} nao pode ser vazio',
                        'min_length' => '{field} deve ter no mino 5 letras ou numeros',
                        'max_length' => '{field} deve ter no maximo 20 letras ou numeros'
                    ]
                ],
                'confirmpassword' => [
                        'label'  => 'Confirmaçao de senha',
                        'rules'  => 'required|matches[password]',
                        'errors' => [
                        'required' => 'Sua {field} nao pode ser vazio'
                    ]
                ],

            ];
        }else{
             $rules = [
                'user' => [
                        'label'  => 'Usuario',
                        'rules'  => 'required|min_length[5]|max_length[20]',
                        'errors' => [
                        'required' => 'Seu {field} nao pode ser vazio',
                        'min_length' => '{field} deve ter no mino 5 letras ou numeros',
                        'max_length' => '{field} deve ter no maximo 20 letras ou numeros'
                    ]
                ],
                'email' => [
                        'label'  => 'Email',
                        'rules'  => 'required|min_length[5]|max_length[50]|valid_email',
                        'errors' => [
                        'required' => 'Seus {field} nao pode ser vazio',
                        'valid_email' => 'Formato do {field} deve ser valido',
                        'min_length' => '{field} deve ter no mino 5 letras ou numeros',
                        'max_length' => '{field} deve ter no maximo 20 letras ou numeros'
                    ]
                ],
                'password' => [
                        'label'  => 'Senha',
                        'rules'  => 'required|min_length[5]|max_length[50]',
                        'errors' => [
                        'required' => 'Sua {field} nao pode ser vazio',
                        'min_length' => '{field} deve ter no mino 5 letras ou numeros',
                        'max_length' => '{field} deve ter no maximo 20 letras ou numeros'
                    ]
                ],
                'ip' => [
                        'label'  => 'MachineIP',
                        'rules'  => 'required|min_length[5]|max_length[50]',
                        'errors' => [
                        'required' => 'Seu {field} nao pode ser vazio',
                        'min_length' => '{field} deve ter no mino 5 letras ou numeros',
                        'max_length' => '{field} deve ter no maximo 20 letras ou numeros'
                    ]
                ],
                'hdid' => [
                        'label'  => 'HarwareID',
                        'rules'  => 'required|min_length[5]|max_length[50]',
                        'errors' => [
                        'required' => 'Seu {field} nao pode ser vazio',
                        'min_length' => '{field} deve ter no mino 5 letras ou numeros',
                        'max_length' => '{field} deve ter no maximo 50 letras ou numeros'
                    ]
                ],
                'plan' => [
                        'label'  => 'Senha',
                        'rules'  => 'required',
                        'errors' => [
                        'required' => 'Sua {field} nao pode ser vazio'
                    ]
                ],
                'confirmpassword' => [
                        'label'  => 'Confirmaçao de senha',
                        'rules'  => 'required|matches[password]',
                        'errors' => [
                        'required' => 'Sua {field} nao pode ser vazio'
                    ]
                ],

            ];
        }
        if(!$this->is_unique('Name', $this->request->getVar('user')) && !$this->is_unique('Mail', $this->request->getVar('email'))){
            if($this->validate($rules)){
                $userModel = new UserModel();
                $licenseModel = new LicenseModel();
                $data = [
                    'Name'     => $this->request->getVar('user'),
                    'Mail'    => $this->request->getVar('email'),
                    'Nivel' => 1,
                    'Status' => 1,
                    'ClientName' => $this->request->getVar('user'),
                    'Password' => $this->request->getVar('password')
                ];
                $userModel->save($data);
                unset($data);
				if(getenv('REG_BONUS_ACTIVE') == 1){
                $check = $userModel->where('Name', $this->request->getVar('user'))->findAll();
                $bonus = strtotime("+".getenv('REG_BONUS_TIME')." day");
                $timestamp = date('Y-m-d H:i:s', $bonus);
                $data = [
                    'UserID' => $check[0]['Id'],
                    'Alias'  => '',
                    'Information1'  => $this->request->getVar('ip'),
                    'Information2'  => $this->request->getVar('hdid'),  
                    'PackageIndex'  => 0,         
                    'PlanIndex' => 1,       
                    'ProductId' => $this->request->getVar('plan'),
                    'Status' => 1,
                    'Expire' =>  $timestamp  
                ];
                $licenseModel->insert($data);
				}
                $data = ['title' => 'Register'];
                return redirect()->to(base_url() . '/user/signup')->with('msg', "Conta registrada com sucesso <a href='{base_url()}/user/signin'>Login</a>");
        
        }else{
            $data = ['title' => 'Register'];
            return redirect()->to(base_url() . '/auth/signup')->with('error', $this->validator); 
        }
        } else {
            return redirect()->to(base_url() . '/user/signup')->with('msg', "Licensa Atualizada");
        }
          
    }
        
  
}