<?php

namespace App\Controllers;
use App\Models\UserModel;
use App\Models\LicenseModel;
class SecurityController extends BaseController
{
    private $PROXY_PORTS = [80, 8080, 3128, 443, 1080];
    private $PROXY_HEADERS = [
        'HTTP_VIA','VIA','Proxy-Connection','HTTP_FORWARDED_FOR','HTTP_X_FORWARDED',
        'HTTP_FORWARDED','HTTP_CLIENT_IP','HTTP_FORWARDED_FOR_IP','X-PROXY-ID','MT-PROXY-ID',
        'X-TINYPROXY','X_FORWARDED_FOR','FORWARDED_FOR','X_FORWARDED','FORWARDED','CLIENT-IP','CLIENT_IP',
        'PROXY-AGENT','HTTP_X_CLUSTER_CLIENT_IP','FORWARDED_FOR_IP','HTTP_PROXY_CONNECTION'
    ];
    public function getIp(): string {
        return array_key_exists("HTTP_CF_CONNECTING_IP", $_SERVER) 
            ? $_SERVER["HTTP_CF_CONNECTING_IP"] 
            : $_SERVER['REMOTE_ADDR'];
    }
    public function hasProxy(): bool {
        foreach($this->PROXY_HEADERS as $header){
            if (array_key_exists($header, $_SERVER) && !empty($_SERVER[$header])) {
                return true;
            }
        }
        foreach($this->PROXY_PORTS as $port) {
            if(@fsockopen($this->getIp(), $port, $errno, $errstr, 1)) {
                return true;
            }
        }
        return false;
    }    
}
