<?php

namespace App\Controllers\User;
use App\Models\UserModel;
use App\Models\LicenseModel;
use App\Controllers\BaseController;
class OverViewController extends BaseController
{
    public function __construct(){
        helper(['form']);
        $this->session = service('session');
    }
    public function index()
    {
        $userModel = new UserModel();
        $licenseModel = new LicenseModel();  
        $user = $userModel->where('Id', session()->get('id'))->findAll();
        $license = $licenseModel->where('UserID', session()->get('id'))->findAll();

        $data['error'] = $this->session->getFlashdata('error');
        $data['title'] = 'Licenses';
        $data['user']= (object)$user[0];
        $data['license']= (array)$license;
        $data['plans'] =  [4 => 'Season 6', 8 => 'Season 8', 12 => 'Season 4', 16 => 'Season 2'];
        $data['packed'] =  [0 => 'Small', 1 => 'Medium', 2 => 'Large'];      
        $data['plansmall'] =  [0 => '50 players', 1 => '100 players', 2 => '150 players', 3 => '200 players'];
        $data['planmedium'] =  [0 => '100 players', 1 => '250 players', 2 => '350 players',3 => '450 players'];
        $data['planlarge'] =  [0 => '250 players', 1 => '500 players', 2 => '1000 players',3 => 'Unlimited Players'];
       $this->smartyView('user/overview', $data);
    }
}
