<?php

namespace App\Controllers\Admin;
use App\Models\UserModel;
use App\Models\LicenseModel;
use App\Controllers\BaseController;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

class MailerController extends BaseController
{
    public function send_email(string $email, string $subject, string $body){

        $mail = new PHPMailer(true);

        try {
            //Server settings
            $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
            $mail->isSMTP();                                            //Send using SMTP
            $mail->Host       = getenv('SMTP_HOST');                     //Set the SMTP server to send through
            $mail->SMTPAuth   = getenv('SMTP_SECURE');                                   //Enable SMTP authentication
            $mail->Username   = getenv('SMTP_USER');                     //SMTP username
            $mail->Password   = getenv('SMTP_PASS');                               //SMTP password
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;            //Enable implicit TLS encryption
            $mail->Port       = getenv('SMTP_PORT');                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

            //Recipients
            $mail->setFrom(getenv('SMTP_SETFROM'), 'AUTHPANEL');
            $mail->addAddress($email, '');     //Add a recipient
            //Content
            $mail->isHTML(true);                                  //Set email format to HTML
            $mail->Subject = $subject;
            $mail->Body    = $body;
            $mail->AltBody = '';

            $mail->send();
            echo 'Message has been sent';
        } catch (Exception $e) {
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        }
    } 
  
}
