{extends file="layout/layout.tpl"}
{block name=main}
    <div class="slim-mainpanel">
      <div class="container">
        <div class="slim-pageheader">
          <ol class="breadcrumb slim-breadcrumb">
            <li class="breadcrumb-item"><a href="#">Admin</a></li>
            <li class="breadcrumb-item"><a href="#">Users</a></li>
            <li class="breadcrumb-item active" aria-current="page">List</li>
          </ol>
          <h6 class="slim-pagetitle">USERS</h6>
        </div>
        <div class="section-wrapper">
          {if $msg}
          <div class="alert alert-success mg-b-0" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">×</span>
            </button>
            <strong>[SUCCESS]</strong> {$msg}
          </div><br>
          {/if}    
          <div class="table-wrapper">
            <table id="datatable1" class="table display responsive nowrap">
              <thead>
                <tr>
                  <th class="wd-15p">UserID</th>
                  <th class="wd-20p">Username</th>
                  <th class="wd-20p">Email</th>
                  <th class="wd-20p">Nivel</th>
                  <th class="wd-20p">Status</th>
                  <th class="wd-25p">Criada</th>
                  <th class="wd-20p">Action</th>
                </tr>
              </thead>
              <tbody>
                 {foreach key=i item=k from=$users}
                <tr>
                  <td>{$k['Id']}</td>
                  <td>{$k['Name']}</td>
                  <td>{$k['Mail']}</td>
                  <td>{$k['Nivel'] === (1) ? 'Cliente' : 'Administrador'}</td>
                  <td>{$k['Status'] === (1) ? 'Ativada' : 'Desativada'}</td>
                  <td>{$k['Date_Create']}</td>
                  <td><div class="dropdown">
                  <button style="height:30px;width:92px;padding:0px 13px;font-size:13px;" class="btn btn-oblong btn-primary bd-0 dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Gerenciar</button>
                  <div class="dropdown-menu" aria-labelledby="dropdownMenuButton" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 42px, 0px); top: 0px; left: 0px; will-change: transform;">
                  <a class="dropdown-item" href="{base_url()}/admin/user/edit/{$k['Id']}">Editar</a>
                  <a onclick="return confirm('Tem certeza que deseja deletar {$k['Name']}?')" class="dropdown-item" href="{base_url()}/admin/user/delete/{$k['Id']}">Deletar</a>
                  </div><!-- dropdown-menu -->
                 </div></td>
                </tr>
               {/foreach}
              </tbody>
            </table>
          </div><!-- table-wrapper -->
        </div><!-- section-wrapper -->
      </div><!-- container -->
    </div><!-- slim-mainpanel -->
    {/block}