{extends file="layout/layout.tpl"}
{block name=main}

<div class="slim-mainpanel">
      <div class="container">
        <div class="slim-pageheader">
          <ol class="breadcrumb slim-breadcrumb">
            <li class="breadcrumb-item"><a href="#">User</a></li>
            <li class="breadcrumb-item"><a href="#">License</a></li>
            <li class="breadcrumb-item active" aria-current="page">Edit</li>
          </ol>
          <h6 class="slim-pagetitle">Edit License</h6>
        </div><!-- slim-pageheader -->

        <div class="section-wrapper">
          {if $error}
          <div class="alert alert-danger mg-b-0" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">×</span>
            </button>
            <strong>[ERROR]</strong> {$error->listErrors()}
          </div><br>
          {/if}
          {if $msg}
          <div class="alert alert-success mg-b-0" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">×</span>
            </button>
            <strong>[SUCCESS]</strong> {$msg}
          </div><br>
          {/if}
          <form method="POST" action="{base_url()}/user/license/edit">
          <div class="form-layout">
            <div class="row mg-b-25">
              <div class="col-lg-4">
                <div class="form-group">
                  <label class="form-control-label">Machine IP: <span class="tx-danger">*</span></label>
                  <input class="form-control" type="text" name="ip" value="{$user->Information1}" placeholder="Enter firstname">
                </div>
              </div><!-- col-4 -->
              <div class="col-lg-4">
                <div class="form-group">
                  <label class="form-control-label">Update: <span class="tx-danger">*</span></label>
                  <input class="form-control" type="text" name="updaten" value="{$user->PackageIndex}" placeholder="Enter lastname" disabled>
                </div>
              </div><!-- col-4 -->
              <div class="col-lg-4">
                <div class="form-group">
                  <label class="form-control-label">Expire Date: <span class="tx-danger">*</span></label>
                  <input class="form-control" type="text" name="expire" value="{$user->Expire}" placeholder="Enter email address" disabled>
                </div>
              </div><!-- col-4 -->
              <div class="col-lg-8">
                <div class="form-group mg-b-10-force">
                  <label class="form-control-label">Hardware ID: <span class="tx-danger">*</span></label>
                  <input class="form-control" type="text" name="hdid" value="{$user->Information2}" placeholder="HardwareID">
                </div>
              </div><!-- col-8 -->
              <div class="col-lg-4">
                <div class="form-group mg-b-10-force">
                  <label class="form-control-label">Level: <span class="tx-danger">*</span></label>
                  <select class="form-control select2" name="status" data-placeholder="Choose status" tabindex="-1" aria-hidden="true" disabled>
                    <option label="Choose Level"></option>
                    <option value="0" {$user->Status === (0) ? 'selected' : ''}>Desativada</option>
                    <option value="1" {$user->Status === (1) ? 'selected' : ''}>Ativada</option>
                  </select>

              </div>
              </div><!-- col-4 -->
              <div class="col-lg-4">
                <div class="form-group mg-b-10-force">
                  <label class="form-control-label">Version: <span class="tx-danger">*</span></label>
                  <select class="form-control select2" name="plan" data-placeholder="Choose plan" tabindex="-1" aria-hidden="true" disabled>
                    <option label="Choose Level"></option>
                    <option value="16" {$user->ProductId === (16) ? 'selected' : ''}>Season 2</option>
                    <option value="12" {$user->ProductId === (12) ? 'selected' : ''}>Season 4</option>
                    <option value="4"  {$user->ProductId === (4) ? 'selected' : ''}>Season 6</option>
                    <option value="8"  {$user->ProductId === (8) ? 'selected' : ''}>Season 8</option>
                  </select>

              </div>
              </div><!-- col-4 -->
            </div><!-- row -->

            <div class="form-layout-footer">
              <button type="submit" id="update" class="btn btn-primary bd-0">Update</button>
              <button class="btn btn-secondary bd-0">Cancel</button>
            </div><!-- form-layout-footer -->
          </div><!-- form-layout -->
                    <input type="hidden" name="{csrf_token()}" value="{csrf_hash()}" />
        </form>
        </div><!-- section-wrapper -->

      </div><!-- container -->
    </div>
{/block}