{extends file="layout/layout.tpl"}
{block name=main}
    <div class="slim-mainpanel">
      <div class="container">
        <div class="slim-pageheader">
          <ol class="breadcrumb slim-breadcrumb">
            <li class="breadcrumb-item"><a href="#">Admin</a></li>
            <li class="breadcrumb-item"><a href="#">Users</a></li>
            <li class="breadcrumb-item active" aria-current="page">List</li>
          </ol>
          <h6 class="slim-pagetitle">USERS</h6>
        </div><!-- slim-pageheader -->

        <div class="section-wrapper">
          {if $msg}
          <div class="alert alert-success mg-b-0" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">×</span>
            </button>
            <strong>[SUCCESS]</strong> {$msg}
          </div><br>
          {/if}    
          <div class="table-wrapper">
            <table id="datatable1" class="table display responsive nowrap">
              <thead>
                <tr>
                  <th class="wd-15p">UserID</th>
                  <th class="wd-15p">Username</th>
                  <th class="wd-20p">Email</th>
                  <th class="wd-15p">Password</th>
                  <th class="wd-10p">Status</th>
                  <th class="wd-25p">CustomerName</th>
                  <th class="wd-25p">Editar</th>
                  <th class="wd-25p">Remove</th>
                </tr>
              </thead>
              <tbody>
                 {foreach key=i item=k from=$users}
                <tr>
                  <td>{$k['Id']}</td>
                  <td>{$k['Name']}</td>
                  <td>{$k['Mail']}</td>
                  <td>{$k['Password']}</td>
                  <td>{$k['Status'] === (1) ? 'Ativada' : 'Desativada'}</td>
                  <td>{$k['ClientName']}</td>
                  <td><a href="{base_url()}/admin/user/edit/{$k['Id']}" class="btn btn-success">Editar</button></td>
                  <td><a href="{base_url()}/admin/user/delete/{$k['Id']}" class="btn btn-success">Remove</button></td>
                </tr>
               {/foreach}
              </tbody>
            </table>
          </div><!-- table-wrapper -->
        </div><!-- section-wrapper -->
      </div><!-- container -->
    </div><!-- slim-mainpanel -->
    {/block}